/*
 * DayCalendarImpl.java
 *
 * Created on November 9, 2004, 11:03 AM
 */
package dop;

import java.util.*;
import java.text.*;
import java.io.*;
import java.rmi.*;
import java.rmi.server.*;

/**
 *
 * @author  garbi
 */
public class DayCalendarImpl extends UnicastRemoteObject implements DayCalendar, Unreferenced {

    private TreeSet eventSet;// TreeSet stores its elements in a tree and maintain order of its elements based on their values or based on a Comparator.
    private String name;
    static private DateFormat dform = DateFormat.getDateInstance(DateFormat.MEDIUM, Locale.US);
    private ArrayList listeners;//ArrayList supports dynamic arrays that can grow as needed.

    /** Creates a new instance of CalendarImpl */
    public DayCalendarImpl(String name) throws RemoteException {
        this.name = name;
        this.listeners = new ArrayList();
        Comparator eventComp = new Comparator() {

            public int compare(Object o1, Object o2) {
                DayEvent e1 = (DayEvent) o1;
                DayEvent e2 = (DayEvent) o2;
                return (e1.when.compareTo(e2.when));// this method returns the value 0 if the argument "e2.when" of type Date is equal to the argument "e1.when" of type Date; a value less than 0 if "e1.when" is before "e2.when"; and a value greater than 0 if "e1.when" is after "e2.when".
            }
        };
        eventSet = new TreeSet(eventComp);//Constructs a new, empty set to store DayEvents, sorted in the order specified by the comparator.
    }

    public boolean isFree(java.util.Date date) throws RemoteException {
        DayEvent testEvent = new DayEvent(date, "test");
        return (!eventSet.contains(testEvent));
    }

    public String[] listEvents() throws RemoteException {
        String[] events = new String[eventSet.size()];
        Iterator iter = eventSet.iterator();
        int i = 0;
        while (iter.hasNext()) {
            events[i++] = iter.next().toString();
        }
        return events;
    }

    public DayEvent plan(DayEvent event) throws RemoteException, CalendarException {
        if (eventSet.contains(event)) {
            throw new CalendarException("Date " + dform.format(event.when) + " is not free");
        }
        eventSet.add(event);
        notifyListeners(event);
        return event;
    }

    private void notifyListeners(DayEvent e) {
        Iterator iter = listeners.iterator();
        while (iter.hasNext()) {
            try {
                ((CalendarListener) iter.next()).eventPlanned(e);//check the implementation of eventPlanned in CalendarClient.
            } catch (RemoteException re) {
                System.err.println(" In notifyListeners method of calss DayCalendarImpl -> Notification failed");
            }
        }
    }

    public String getName() throws RemoteException {
        return name;
    }

    public void addListener(CalendarListener l) throws RemoteException {
        listeners.add(l);
    }
    private static Date askForDate(final BufferedReader kbdIn)
            throws IOException {

        String when;
        int attempts = 3;
        Date date = null;
        while (true) {
            try {
                System.out.print("When: ");
                when = kbdIn.readLine();
                if (when.trim().toLowerCase().equals("quit")) {//trim()Returns a copy of the string, with leading and trailing whitespace omitted.
                    break;
                }
                date = dform.parse(when);//Parses text from the beginning of the given string to produce a date.
                break;
            } catch (ParseException e) {
                System.out.print("oups, wrong date format");
                if (attempts == 0) {
                    System.out.println(", no more attempts!");
                    break;
                }
                System.out.println(", try again!");
                attempts--;
            }
        }

        return date;
    }

    public DayEvent getEventForDate(Date date) throws RemoteException {
        Iterator iter = eventSet.iterator();
        while (iter.hasNext()) {
            DayEvent d = (DayEvent) iter.next();
            if (d.when.compareTo(date) == 0) {
                return d;
            }
        }
        return null;
    }

    @Override
    protected void finalize() throws Throwable {
        System.out.println("In finalize method of calss DayCalendarImpl -> This time, " + name + " is really about to be garbage collected... so bye bye cruel world!");
    }

    public void unreferenced() {
        System.out.println("In unrefrenced method of calss DayCalendarImpl -> Oups, " + name + " is no longer remotely referenced!");
    }
}
